ORCA/M Asm65816 2.1.0

0001 954D              **********************************************************************
0002 954D              *
0003 954D              * Patch to Text Tools (ROM 03)
0004 954D              *
0005 954D              * Copyright 1991-1992 Apple Computer, Inc
0006 954D              * All Rights Reserved
0007 954D              *
0008 954D              **********************************************************************
0009 954D              *
0010 954D              * 5-Nov-91          Dave Lyons
0011 954D              *
0012 954D              * New file (started with skeleton from TS2 Text.Tools.asm).
0013 954D              *
0014 954D              * Patch TextVersion (version $8301).
0015 954D              *
0016 954D              * Patch GetInputDevice, GetOutputDevice, GetErrorDevice to pre-zero
0017 954D              * the result space for the device type, so we don't return garbage
0018 954D              * for the Set calls to choke on (at -least- for SetInputDevice, it's
0019 954D              * a problem to have device type $xx02, for a RAM-based driver).
0020 954D              *
0021 954D              * (By the way, this means that SaveTextState/RestoreTextState breaks
0022 954D              * under APW 2.0, since a RAM-based Text Tools driver is active.)
0023 954D              *
0024 954D              * 5-Feb-92          Dave Lyons
0025 954D              *
0026 954D              * Version $0301 for 6.0 final.
0027 954D              *
0028 954D              **********************************************************************
0029 954D                       include 'all.macros' 
0030 954D                       include ':::sys.equs.asm' 
0031 954D
0032 954D
0033 954D              TextVersionNumber equ   $0301
0034 954D
0035 954D              ;-----------------------------------------------------------
0036 954D              ;
0037 954D              ; Equates for addresses in bank E1.
0038 954D              ;
0039 954D
0040 954D              ANDin    equ   $E115AA
0041 954D              ORin     equ   ANDin+1
0042 954D              ANDout   equ   ORin+1
0043 954D              ORout    equ   ANDout+1
0044 954D              ANDerr   equ   ORout+1
0045 954D              ORerr    equ   ANDerr+1
0046 954D              DevType  equ   ORerr+1
0047 954D              DevPtr   equ   DevType+3
0048 954D              InDevPtr equ   DevPtr
0049 954D              OutDevPt equ   InDevPtr+4
0050 954D              ErrDevPt equ   OutDevPt+4
0051 954D              ErrHook  equ   ErrDevPt+4
0052 954D
0053 954D
0054 954D              ****************************************************************
0055 954D              *
0056 954D              TTCallTable PROC EXPORT 
0057 954D              *
0058 954D              * Contains the calls to patch in the text tools tool set.
0059 954D              *
0060 954D              *
0061 954D              * Inputs:
0062 954D              *                   none
0063 954D              *
0064 954D              * Outputs:
0065 954D              *                   none
0066 954D              *
0067 954D              * External Refs:
0068 954D                       import TextVersion 
0069 954D                       import TextBootInit 
0070 954D                       import GetInDev 
0071 954D                       import GetOutDev 
0072 954D                       import GetErrDev 
0073 954D              *
0074 954D              * Entry Points:
0075 954D              *                   none
0076 954D              *
0077 954D                       longa on                       ; mode
0078 954D                       longi on
0079 954D              *
0080 954D              ****************************************************************
0081 954D
0082 954D              Here      
0083 954D 25 00 00 00           DC L:(TheEnd-Here)/4           ; num calls +1
0084 9551 E5 98 02 00           DC L:TextBootInit-1            ;$010C TextBootInit
0085 9555 00 00 00 00           DC L:0                         ;$020C TextStartUp
0086 9559 00 00 00 00           DC L:0                         ;$030C TextShutDown
0087 955D E0 98 02 00           DC L:TextVersion-1             ;$040C TextVersion
0088 9561 00 00 00 00           DC L:0                         ;$050C TextReset
0089 9565 00 00 00 00           DC L:0                         ;$060C TextStatus
0090 9569 00 00 00 00           DC L:0                         ;$070C
0091 956D 00 00 00 00           DC L:0                         ;$080C
0092 9571 00 00 00 00           DC L:0                         ;$090C SetInGlobals
0093 9575 00 00 00 00           DC L:0                         ;$0A0C SetOutGlobals
0094 9579 00 00 00 00           DC L:0                         ;$0B0C SetErrorGlobals
0095 957D 00 00 00 00           DC L:0                         ;$0C0C GetInGlobals
0096 9581 00 00 00 00           DC L:0                         ;$0D0C GetOutGlobals
0097 9585 00 00 00 00           DC L:0                         ;$0E0C GetErrGlobals
0098 9589 00 00 00 00           DC L:0                         ;$0F0C SetInputDevice
0099 958D 00 00 00 00           DC L:0                         ;$100C SetOutputDevice
0100 9591 00 00 00 00           DC L:0                         ;$110C SetErrorDevice
0101 9595 EA 98 02 00           DC L:GetInDev-1                ;$120C, patched 4-Nov-91 DAL
0102 9599 F3 98 02 00           DC L:GetOutDev-1               ;$130C, patched 4-Nov-91 DAL
0103 959D FC 98 02 00           DC L:GetErrDev-1               ;$140C, patched 4-Nov-91 DAL
0104 95A1 00 00 00 00           DC L:0                         ;$150C InitTextDev
0105 95A5 00 00 00 00           DC L:0                         ;$160C CtlTextDev
0106 95A9 00 00 00 00           DC L:0                         ;$170C StatusTextDev
0107 95AD 00 00 00 00           DC L:0                         ;$180C WriteChar
0108 95B1 00 00 00 00           DC L:0                         ;$190C ErrWriteChar
0109 95B5 00 00 00 00           DC L:0                         ;$1A0C WriteLine
0110 95B9 00 00 00 00           DC L:0                         ;$1B0C ErrWriteLine
0111 95BD 00 00 00 00           DC L:0                         ;$1C0C WriteString
0112 95C1 00 00 00 00           DC L:0                         ;$1D0C ErroWriteString
0113 95C5 00 00 00 00           DC L:0                         ;$1E0C TextWriteBlock
0114 95C9 00 00 00 00           DC L:0                         ;$1F0C ErrWriteBlock
0115 95CD 00 00 00 00           DC L:0                         ;$200C WriteCString
0116 95D1 00 00 00 00           DC L:0                         ;$210C ErrWriteCString
0117 95D5 00 00 00 00           DC L:0                         ;$220C ReadChar
0118 95D9 00 00 00 00           DC L:0                         ;$230C TextReadBlock
0119 95DD 00 00 00 00           DC L:0                         ;$240C ReadLine
0120 95E1              TheEnd    
0121 95E1
0122 95E1                       ENDP 
0123 95E1
0124 95E1
0125 95E1
0126 95E1              ****************************************************************
0127 95E1              *
0128 95E1              StdTextCalls PROC 
0129 95E1              *
0130 95E1              * Contains the Version call and the boot init call
0131 95E1              *
0132 95E1              *
0133 95E1              * Inputs:
0134 95E1              *                   none
0135 95E1              *
0136 95E1              * Outputs:
0137 95E1              *                   none
0138 95E1              *
0139 95E1              * External Refs:
0140 95E1              *                   none
0141 95E1              *
0142 95E1              * Entry Points:
0143 95E1                       ENTRY TextVersion 
0144 95E1                       ENTRY TextBootInit 
0145 95E1              *
0146 95E1                       longa on                       ; mode
0147 95E1                       longi on
0148 95E1              *
0149 95E1              ****************************************************************
0150 95E1
0151 95E1 A9 01 03     TextVersion lda   #TextVersionNumber
0152 95E4 83 07                 sta   7,s
0153 95E6
0154 95E6 A9 00 00     TextBootInit lda   #0
0155 95E9 18                    clc   
0156 95EA 6B                    rtl   
0157 95EB
0158 95EB                       ENDP 
0159 95EB
0160 95EB
0161 95EB              ****************************************************************
0162 95EB              *
0163 95EB              * GetInDev, GetOutDev, GetErrDev
0164 95EB              *
0165 95EB              * Patched 5-Nov-91 DAL to pre-zero the device-type output word.
0166 95EB              *
0167 95EB              ****************************************************************
0168 95EB              GetInDev proc export 
0169 95EB A9 00 00              lda   #0
0170 95EE 83 0B                 sta   11,s
0171 95F0 5C 98 C0 FE           jml   >$fec098
0172 95F4                       EndP 
0173 95F4
0174 95F4              GetOutDev proc export 
0175 95F4 A9 00 00              lda   #0
0176 95F7 83 0B                 sta   11,s
0177 95F9 5C CD C0 FE           jml   >$fec0cd
0178 95FD                       EndP 
0179 95FD
0180 95FD              GetErrDev proc export 
0181 95FD A9 00 00              lda   #0
0182 9600 83 0B                 sta   11,s
0183 9602 5C D2 C0 FE           jml   >$fec0d2
0184 9606                       EndP 
0185 9606
0186 9606                       END   
